/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Locale;
import javax.media.j3d.Morph;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Shape3DCompileRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Text3DRetained;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;

public class PickInfo {
    static final int PICK_ALL = 1;
    static final int PICK_ANY = 2;
    private SceneGraphPath sgp;
    private Node node;
    private Transform3D l2vw;
    private Point3d closestIntersectionPoint;
    private double closestDistance;
    private IntersectionInfo[] intersectionInfoArr;
    private ArrayList intersectionInfoList = new ArrayList();
    private boolean intersectionInfoListSorted = false;
    private Transform3D l2vwRef;
    private Node nodeRef;
    public static final int PICK_BOUNDS = 1;
    public static final int PICK_GEOMETRY = 2;
    public static final int SCENEGRAPHPATH = 1;
    public static final int NODE = 2;
    public static final int LOCAL_TO_VWORLD = 4;
    public static final int CLOSEST_INTERSECTION_POINT = 8;
    public static final int CLOSEST_DISTANCE = 16;
    public static final int CLOSEST_GEOM_INFO = 32;
    public static final int ALL_GEOM_INFO = 64;

    PickInfo() {
    }

    void setSceneGraphPath(SceneGraphPath sceneGraphPath) {
        this.sgp = sceneGraphPath;
    }

    void setNode(Node node) {
        this.node = node;
    }

    void setLocalToVWorld(Transform3D transform3D) {
        this.l2vw = transform3D;
    }

    void setClosestIntersectionPoint(Point3d point3d) {
        this.closestIntersectionPoint = point3d;
    }

    void setClosestDistance(double d2) {
        this.closestDistance = d2;
    }

    void setLocalToVWorldRef(Transform3D transform3D) {
        this.l2vwRef = transform3D;
    }

    void setNodeRef(Node node) {
        this.nodeRef = node;
    }

    IntersectionInfo createIntersectionInfo() {
        return new IntersectionInfo();
    }

    void insertIntersectionInfo(IntersectionInfo intersectionInfo) {
        this.intersectionInfoList.add(intersectionInfo);
        this.intersectionInfoListSorted = false;
    }

    void sortIntersectionInfoArray(IntersectionInfo[] intersectionInfoArray) {
        class Sort {
            IntersectionInfo[] iInfoArr;

            Sort(IntersectionInfo[] intersectionInfoArray) {
                this.iInfoArr = intersectionInfoArray;
            }

            void sorting() {
                if (this.iInfoArr.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.iInfoArr.length - 1);
                }
            }

            final void insertSort() {
                for (int i2 = 0; i2 < this.iInfoArr.length; ++i2) {
                    for (int i3 = i2; i3 > 0 && this.iInfoArr[i3 - 1].distance > this.iInfoArr[i3].distance; --i3) {
                        IntersectionInfo intersectionInfo = this.iInfoArr[i3];
                        this.iInfoArr[i3] = this.iInfoArr[i3 - 1];
                        this.iInfoArr[i3 - 1] = intersectionInfo;
                    }
                }
            }

            final void quicksort(int n2, int n3) {
                int n4 = n2;
                int n5 = n3;
                double d2 = this.iInfoArr[(n2 + n3) / 2].distance;
                while (true) {
                    if (this.iInfoArr[n4].distance < d2) {
                        ++n4;
                        continue;
                    }
                    while (d2 < this.iInfoArr[n5].distance) {
                        --n5;
                    }
                    if (n4 <= n5) {
                        IntersectionInfo intersectionInfo = this.iInfoArr[n4];
                        this.iInfoArr[n4] = this.iInfoArr[n5];
                        this.iInfoArr[n5] = intersectionInfo;
                        ++n4;
                        --n5;
                    }
                    if (n4 > n5) break;
                }
                if (n2 < n5) {
                    this.quicksort(n2, n5);
                }
                if (n2 < n3) {
                    this.quicksort(n4, n3);
                }
            }
        }
        new Sort(intersectionInfoArray).sorting();
        this.intersectionInfoListSorted = true;
    }

    static void sortPickInfoArray(PickInfo[] pickInfoArray) {
        class Sort {
            PickInfo[] pIArr;

            Sort(PickInfo[] pickInfoArray) {
                this.pIArr = pickInfoArray;
            }

            void sorting() {
                if (this.pIArr.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.pIArr.length - 1);
                }
            }

            final void insertSort() {
                for (int i2 = 0; i2 < this.pIArr.length; ++i2) {
                    for (int i3 = i2; i3 > 0 && this.pIArr[i3 - 1].closestDistance > this.pIArr[i3].closestDistance; --i3) {
                        PickInfo pickInfo = this.pIArr[i3];
                        this.pIArr[i3] = this.pIArr[i3 - 1];
                        this.pIArr[i3 - 1] = pickInfo;
                    }
                }
            }

            final void quicksort(int n2, int n3) {
                int n4 = n2;
                int n5 = n3;
                double d2 = this.pIArr[(n2 + n3) / 2].closestDistance;
                while (true) {
                    if (this.pIArr[n4].closestDistance < d2) {
                        ++n4;
                        continue;
                    }
                    while (d2 < this.pIArr[n5].closestDistance) {
                        --n5;
                    }
                    if (n4 <= n5) {
                        PickInfo pickInfo = this.pIArr[n4];
                        this.pIArr[n4] = this.pIArr[n5];
                        this.pIArr[n5] = pickInfo;
                        ++n4;
                        --n5;
                    }
                    if (n4 > n5) break;
                }
                if (n2 < n5) {
                    this.quicksort(n2, n5);
                }
                if (n2 < n3) {
                    this.quicksort(n4, n3);
                }
            }
        }
        new Sort(pickInfoArray).sorting();
    }

    public SceneGraphPath getSceneGraphPath() {
        return this.sgp;
    }

    public Node getNode() {
        return this.node;
    }

    public Transform3D getLocalToVWorld() {
        return this.l2vw;
    }

    public Point3d getClosestIntersectionPoint() {
        return this.closestIntersectionPoint;
    }

    public double getClosestDistance() {
        return this.closestDistance;
    }

    Transform3D getLocalToVWorldRef() {
        return this.l2vwRef;
    }

    Node getNodeRef() {
        return this.nodeRef;
    }

    public IntersectionInfo[] getIntersectionInfos() {
        if (!this.intersectionInfoListSorted) {
            this.intersectionInfoArr = new IntersectionInfo[this.intersectionInfoList.size()];
            this.intersectionInfoArr = this.intersectionInfoList.toArray(this.intersectionInfoArr);
            this.sortIntersectionInfoArray(this.intersectionInfoArr);
        }
        return this.intersectionInfoArr;
    }

    static ArrayList initSceneGraphPath(NodeRetained nodeRetained) {
        ArrayList<NodeRetained> arrayList = new ArrayList<NodeRetained>(5);
        do {
            if (!nodeRetained.source.getCapability(1)) continue;
            arrayList.add(nodeRetained);
        } while ((nodeRetained = nodeRetained.parent) != null);
        return arrayList;
    }

    private static Node[] createPath(NodeRetained nodeRetained, BranchGroupRetained branchGroupRetained, GeometryAtom geometryAtom, ArrayList arrayList) {
        ArrayList arrayList2 = PickInfo.retrievePath(nodeRetained, branchGroupRetained, geometryAtom.source.key);
        assert (arrayList2 != null);
        return PickInfo.mergePath(arrayList2, arrayList);
    }

    private static boolean inside(BranchGroupRetained[] branchGroupRetainedArray, BranchGroupRetained branchGroupRetained) {
        if (branchGroupRetained == null || branchGroupRetainedArray == null) {
            return true;
        }
        for (int i2 = 0; i2 < branchGroupRetainedArray.length; ++i2) {
            if (branchGroupRetainedArray[i2] != branchGroupRetained) continue;
            return true;
        }
        return false;
    }

    private static ArrayList retrievePath(NodeRetained nodeRetained, NodeRetained nodeRetained2, HashKey hashKey) {
        ArrayList<NodeRetained> arrayList = new ArrayList<NodeRetained>(5);
        NodeRetained nodeRetained3 = nodeRetained;
        if (nodeRetained3.inSharedGroup) {
            hashKey = new HashKey(hashKey);
        }
        do {
            if (nodeRetained3 == nodeRetained2) {
                return arrayList;
            }
            if (nodeRetained3.source.getCapability(1)) {
                arrayList.add(nodeRetained3);
            }
            if (!(nodeRetained3 instanceof SharedGroupRetained)) continue;
            String string = hashKey.getLastNodeId();
            Vector vector = ((SharedGroupRetained)nodeRetained3).parents;
            int n2 = vector.size();
            NodeRetained nodeRetained4 = nodeRetained3;
            for (int i2 = 0; i2 < n2; ++i2) {
                NodeRetained nodeRetained5 = (NodeRetained)vector.elementAt(i2);
                if (!nodeRetained5.nodeId.equals(string)) continue;
                nodeRetained3 = nodeRetained5;
                arrayList.add(nodeRetained3);
                break;
            }
            if (nodeRetained3 != nodeRetained4) continue;
            return null;
        } while ((nodeRetained3 = nodeRetained3.parent) != null);
        if (nodeRetained2 == null) {
            return arrayList;
        }
        return null;
    }

    private static Node[] mergePath(ArrayList arrayList, ArrayList arrayList2) {
        int n2;
        int n3 = arrayList.size();
        int n4 = arrayList2 == null ? n3 : n3 + arrayList2.size();
        Node[] nodeArray = new Node[n4];
        int n5 = n4 - 1;
        for (n2 = 0; n2 < n3; ++n2) {
            nodeArray[n5 - n2] = (Node)((NodeRetained)arrayList.get((int)n2)).source;
        }
        int n6 = 0;
        while (n2 < n4) {
            nodeArray[n5 - n2] = (Node)((NodeRetained)arrayList2.get((int)n6)).source;
            ++n2;
            ++n6;
        }
        return nodeArray;
    }

    static void sortGeomAtoms(GeometryAtom[] geometryAtomArray, PickShape pickShape) {
        double[] dArray = new double[geometryAtomArray.length];
        Point4d point4d = new Point4d();
        for (int i2 = 0; i2 < geometryAtomArray.length; ++i2) {
            pickShape.intersect(geometryAtomArray[i2].source.vwcBounds, point4d);
            dArray[i2] = point4d.w;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Sort {
            GeometryAtom[] atoms;
            final /* synthetic */ double[] val$distance;

            Sort(GeometryAtom[] geometryAtomArray) {
                this.val$distance = (double[])geometryAtomArray;
                this.atoms = var1_1;
            }

            void sorting() {
                if (this.atoms.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.atoms.length - 1);
                }
            }

            final void insertSort() {
                for (int i2 = 0; i2 < this.atoms.length; ++i2) {
                    for (int i3 = i2; i3 > 0 && this.val$distance[i3 - 1] > this.val$distance[i3]; --i3) {
                        double d2 = this.val$distance[i3];
                        this.val$distance[i3] = this.val$distance[i3 - 1];
                        this.val$distance[i3 - 1] = d2;
                        GeometryAtom geometryAtom = this.atoms[i3];
                        this.atoms[i3] = this.atoms[i3 - 1];
                        this.atoms[i3 - 1] = geometryAtom;
                    }
                }
            }

            final void quicksort(int n2, int n3) {
                int n4 = n2;
                int n5 = n3;
                double d2 = this.val$distance[(n2 + n3) / 2];
                while (true) {
                    if (this.val$distance[n4] < d2) {
                        ++n4;
                        continue;
                    }
                    while (d2 < this.val$distance[n5]) {
                        --n5;
                    }
                    if (n4 <= n5) {
                        double d3 = this.val$distance[n4];
                        this.val$distance[n4] = this.val$distance[n5];
                        this.val$distance[n5] = d3;
                        GeometryAtom geometryAtom = this.atoms[n4];
                        this.atoms[n4] = this.atoms[n5];
                        this.atoms[n5] = geometryAtom;
                        ++n4;
                        --n5;
                    }
                    if (n4 > n5) break;
                }
                if (n2 < n5) {
                    this.quicksort(n2, n5);
                }
                if (n2 < n3) {
                    this.quicksort(n4, n3);
                }
            }
        }
        new Sort(geometryAtomArray, dArray).sorting();
    }

    static ArrayList getPickInfos(ArrayList arrayList, BranchGroupRetained branchGroupRetained, GeometryAtom[] geometryAtomArray, Locale locale, int n2, int n3) {
        ArrayList<PickInfo> arrayList2 = new ArrayList<PickInfo>(5);
        ArrayList<NodeRetained> arrayList3 = null;
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < geometryAtomArray.length; ++i2) {
            int n4;
            int n5;
            Object object;
            Node[] nodeArray;
            assert (geometryAtomArray[i2] != null && geometryAtomArray[i2].source != null);
            PickInfo pickInfo = null;
            Shape3DRetained shape3DRetained = geometryAtomArray[i2].source;
            NodeRetained nodeRetained = shape3DRetained.sourceNode;
            if (!PickInfo.inside(shape3DRetained.branchGroupPath, branchGroupRetained) || nodeRetained == null) continue;
            if (nodeRetained instanceof Shape3DRetained) {
                nodeArray = (Node[])nodeRetained;
                object = null;
                for (n5 = 0; n5 < nodeArray.geometryList.size() && (object = (GeometryRetained)nodeArray.geometryList.get(n5)) == null; ++n5) {
                }
                if (object == null) continue;
                if (object instanceof Text3DRetained) {
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<NodeRetained>(3);
                    } else {
                        n5 = arrayList3.size();
                        n4 = 0;
                        for (int i3 = 0; i3 < n5; ++i3) {
                            if (arrayList3.get(i3) != nodeRetained) continue;
                            n4 = 1;
                            break;
                        }
                        if (n4 != 0) continue;
                    }
                    arrayList3.add(nodeRetained);
                }
            }
            if (nodeRetained instanceof Shape3DCompileRetained) {
                nodeArray = (Shape3DCompileRetained)nodeRetained;
                object = null;
                n5 = 1;
                for (n4 = 0; n4 < nodeArray.srcList.length; ++n4) {
                    pickInfo = null;
                    if ((n2 & 1) != 0) {
                        if (n5 != 0) {
                            object = PickInfo.createPath(nodeRetained, branchGroupRetained, geometryAtomArray[i2], arrayList);
                            n5 = 0;
                        }
                        if (object != null) {
                            SceneGraphPath sceneGraphPath = new SceneGraphPath(locale, (Node[])object, (Node)nodeArray.srcList[n4]);
                            sceneGraphPath.setTransform(shape3DRetained.getCurrentLocalToVworld(0));
                            if (pickInfo == null) {
                                pickInfo = new PickInfo();
                            }
                            pickInfo.setSceneGraphPath(sceneGraphPath);
                        }
                    }
                    if ((n2 & 2) != 0) {
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setNode((Node)nodeArray.srcList[n4]);
                    }
                    if ((n2 & 4) != 0) {
                        Transform3D transform3D = geometryAtomArray[i2].source.getCurrentLocalToVworld();
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setLocalToVWorld(new Transform3D(transform3D));
                    }
                    if ((n2 & 0x10) != 0 || (n2 & 0x20) != 0 || (n2 & 8) != 0 || (n2 & 0x40) != 0) {
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setNodeRef((Node)nodeArray.srcList[n4]);
                        Transform3D transform3D = geometryAtomArray[i2].source.getCurrentLocalToVworld();
                        pickInfo.setLocalToVWorldRef(transform3D);
                    }
                    if (pickInfo != null) {
                        arrayList2.add(pickInfo);
                    }
                    if (n3 != 2) continue;
                    return arrayList2;
                }
                continue;
            }
            nodeArray = null;
            if ((n2 & 1) != 0 && (nodeArray = PickInfo.createPath(nodeRetained, branchGroupRetained, geometryAtomArray[i2], arrayList)) != null) {
                object = new SceneGraphPath(locale, nodeArray, (Node)nodeRetained.source);
                object.setTransform(shape3DRetained.getCurrentLocalToVworld(0));
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setSceneGraphPath((SceneGraphPath)object);
            }
            if ((n2 & 2) != 0) {
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setNode((Node)nodeRetained.source);
            }
            if ((n2 & 4) != 0) {
                object = geometryAtomArray[i2].source.getCurrentLocalToVworld();
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setLocalToVWorld(new Transform3D((Transform3D)object));
            }
            if ((n2 & 0x10) != 0 || (n2 & 0x20) != 0 || (n2 & 8) != 0 || (n2 & 0x40) != 0) {
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setNodeRef((Node)nodeRetained.source);
                object = geometryAtomArray[i2].source.getCurrentLocalToVworld();
                pickInfo.setLocalToVWorldRef((Transform3D)object);
            }
            if (pickInfo != null) {
                arrayList2.add(pickInfo);
            }
            if (n3 != 2) continue;
            return arrayList2;
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PickInfo[] pick(Object object, GeometryAtom[] geometryAtomArray, int n2, int n3, PickShape pickShape, int n4) {
        int n5;
        PickInfo[] pickInfoArray = null;
        Locale locale = null;
        BranchGroupRetained branchGroupRetained = null;
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        if (object instanceof Locale) {
            locale = (Locale)object;
        } else if (object instanceof BranchGroupRetained) {
            branchGroupRetained = (BranchGroupRetained)object;
            locale = branchGroupRetained.locale;
        }
        Object object2 = locale.universe.sceneGraphLock;
        synchronized (object2) {
            if (branchGroupRetained != null) {
                arrayList = PickInfo.initSceneGraphPath(branchGroupRetained);
            }
            arrayList2 = PickInfo.getPickInfos(arrayList, branchGroupRetained, geometryAtomArray, locale, n3, n4);
        }
        if (n2 == 2 && arrayList2 != null && (n5 = arrayList2.size()) > 0) {
            object2 = null;
            Node node = null;
            for (int i2 = n5 - 1; i2 >= 0; --i2) {
                int n6;
                object2 = (PickInfo)arrayList2.get(i2);
                node = ((PickInfo)object2).getNode();
                if (node == null) {
                    node = ((PickInfo)object2).getNodeRef();
                }
                if (node instanceof Shape3D) {
                    if (!node.getCapability(12)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo0"));
                    }
                    for (n6 = 0; n6 < ((Shape3D)node).numGeometries(); ++n6) {
                        Geometry geometry = ((Shape3D)node).getGeometry(n6);
                        if (geometry == null) continue;
                        if (!geometry.getCapability(18)) {
                            throw new CapabilityNotSetException(J3dI18N.getString("PickInfo1"));
                        }
                        if (geometry instanceof GeometryArray) {
                            if (!geometry.getCapability(0)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo2"));
                            }
                            if (!geometry.getCapability(8)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo3"));
                            }
                            if (!geometry.getCapability(17)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo4"));
                            }
                            if (!(geometry instanceof IndexedGeometryArray) || geometry.getCapability(9)) continue;
                            throw new CapabilityNotSetException(J3dI18N.getString("PickInfo5"));
                        }
                        if (!(geometry instanceof CompressedGeometry) || geometry.getCapability(2)) continue;
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo0"));
                    }
                    if (!((Shape3DRetained)node.retained).intersect((PickInfo)object2, pickShape, n3)) {
                        arrayList2.remove(i2);
                        continue;
                    }
                    if (n4 != 2) continue;
                    pickInfoArray = new PickInfo[]{object2};
                    return pickInfoArray;
                }
                if (!(node instanceof Morph)) continue;
                if (!node.getCapability(12)) {
                    throw new CapabilityNotSetException(J3dI18N.getString("PickInfo6"));
                }
                n6 = ((MorphRetained)node.retained).getNumGeometryArrays();
                for (int i3 = 0; i3 < n6; ++i3) {
                    GeometryArray geometryArray = ((Morph)node).getGeometryArray(i3);
                    if (geometryArray == null) continue;
                    if (!geometryArray.getCapability(18)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo1"));
                    }
                    if (!geometryArray.getCapability(0)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo2"));
                    }
                    if (!geometryArray.getCapability(8)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo3"));
                    }
                    if (!geometryArray.getCapability(17)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo4"));
                    }
                    if (!(geometryArray instanceof IndexedGeometryArray) || geometryArray.getCapability(9)) continue;
                    throw new CapabilityNotSetException(J3dI18N.getString("PickInfo5"));
                }
                if (!((MorphRetained)node.retained).intersect((PickInfo)object2, pickShape, n3)) {
                    arrayList2.remove(i2);
                    continue;
                }
                if (n4 != 2) continue;
                pickInfoArray = new PickInfo[]{object2};
                return pickInfoArray;
            }
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            pickInfoArray = new PickInfo[arrayList2.size()];
            return arrayList2.toArray(pickInfoArray);
        }
        return null;
    }

    public class IntersectionInfo {
        private int geomIndex;
        private Geometry geom;
        private Point3d intersectionPoint;
        private double distance;
        private int[] vertexIndices;

        IntersectionInfo() {
        }

        void setGeometryIndex(int n2) {
            this.geomIndex = n2;
        }

        void setGeometry(Geometry geometry) {
            this.geom = geometry;
        }

        void setIntersectionPoint(Point3d point3d) {
            assert (point3d != null);
            this.intersectionPoint = new Point3d(point3d);
        }

        void setDistance(double d2) {
            this.distance = d2;
        }

        void setVertexIndices(int[] nArray) {
            assert (nArray != null);
            this.vertexIndices = new int[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.vertexIndices[i2] = nArray[i2];
            }
        }

        public int getGeometryIndex() {
            return this.geomIndex;
        }

        public Geometry getGeometry() {
            return this.geom;
        }

        public Point3d getIntersectionPoint() {
            return this.intersectionPoint;
        }

        public double getDistance() {
            return this.distance;
        }

        public int[] getVertexIndices() {
            return this.vertexIndices;
        }
    }
}

